/*
 * Decompiled with CFR 0.152.
 */
package wlirc2;

import java.io.IOException;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.lcdui.ItemStateListener;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;
import wlirc2.BluetoothIrc;
import wlirc2.Console;
import wlirc2.DCC;
import wlirc2.Database;
import wlirc2.Encoding;
import wlirc2.Irc;
import wlirc2.Listener;
import wlirc2.Message;
import wlirc2.PollHttpIrc;
import wlirc2.Profile;
import wlirc2.ScreenOutput;
import wlirc2.SocketIrc;
import wlirc2.Utils;
import wlirc2.WindowItem;

public class WLIrc2
extends MIDlet
implements CommandListener,
ItemCommandListener,
ItemStateListener {
    public static final String VERSION = "2.0 Beta 5";
    protected static Hashtable ctcplist = new Hashtable();
    private Display display;
    protected static Form mainForm;
    protected static ScreenOutput debugWindow;
    private Database db;
    private TextField tfgateway = null;
    private TextField tfhost = null;
    private TextField tfnick = null;
    private TextField tffriends = null;
    private TextField tfrealname = null;
    private TextField tfchannel = null;
    private TextField tfpolltime = null;
    private TextField tfwindowwidth = null;
    private TextField tfwindowheight = null;
    private ChoiceGroup cggui = null;
    private ChoiceGroup cgwait = null;
    private ChoiceGroup cgconnection = null;
    private ChoiceGroup cgnotifiertype = null;
    private ChoiceGroup cgnotify = null;
    private ChoiceGroup cgdcc = null;
    private ChoiceGroup cgdebug = null;
    private ChoiceGroup cgencoding = null;
    private ChoiceGroup cgautoconnect = null;
    private TextField tfStartupScript = null;
    private TextField tfpassword = null;
    private TextField tfport = null;
    private TextField tfEncoding = null;
    private TextField tfProfileName = null;
    private TextField tfmaxLinesWindow = null;
    private List notifyList = null;
    private List advancedList = null;
    private List profileList = null;
    private Form notifyForm = null;
    private Command exitCommand = new Command("Exit", 1, 5);
    protected Command connectCommand = new Command("Connect", 1, 1);
    private Command configCommand = new Command("Configuration", 1, 2);
    private Command newprofileCommand = new Command("New Profile", 1, 2);
    private Command removeCommand = new Command("Remove", 1, 2);
    private Command advancedCommand = new Command("Advanced", 1, 3);
    private Command okCommand = new Command("Save", 1, 1);
    private Command editCommand = new Command("Edit", 1, 1);
    private Command cancelCommand = new Command("Cancel", 1, 1);
    private Command guiCommand = new Command("Display settings", 1, 4);
    private Command fontCommand = new Command("Change font", 1, 4);
    private Command testCommand = new Command("Test", 4, 4);
    private Command notifyCommand = new Command("Notifiers", 1, 4);
    private Command addProfileCommand = new Command("Add profile", 1, 4);
    protected Command resumeCommand = new Command("Resume connection", 1, 1);
    protected Command fileBrowser = new Command("FileBrowser", 1, 5);
    private Form configForm;
    private StringItem buttonFont = null;
    private StringItem buttonTest = null;
    private static final String AUTOCONNECT = "Enable profile";
    private static final String ADVANCED_CONNECTION = "Connection";
    private static final String ADVANCED_HTTP = "Http";
    private static final String ADVANCED_DCC = "Dcc";
    private static final String ADVANCED_SERVER = "Server";
    private static final String ADVANCED_ENCODING = "Text encoding";
    private static final String DCC_PROXY = "Use DCC proxy";
    private static final String SOCKET_POLL = "Socket poll";
    private static final String NOTIFIER_TYPE_ALERT = "MessageBox";
    private static final String NOTIFIER_TYPE_SOUND = "Beep";
    private static final String NOTIFIER_TYPE_LOUD_SOUND = "Midi tones";
    private static final String NOTIFIER_TYPE_VIBRATE = "Vibrate";
    private static final String NOTIFIER_TYPE_FLASHLIGT = "Flashlight";
    private static final String NOTIFIER_TYPE_BACKGROUND = "Activate from background";
    private static final String NOTIFY_FRIEND = "Friends";
    private static final String NOTIFY_PRIV = "Private";
    private static final String NOTIFY_CHAN = "Channels";
    private static final String CON_SOCKET = "Socket";
    private static final String CON_HTTPPOLL = "Http";
    private static final String CON_BLUETOOTH = "Bluetooth";
    private static final String INFO_LITTLE = "No extra window";
    private static final String INFO_NORMAL = "Status window";
    private static final String INFO_DEBUG = "Debug window";
    private static final String USE_WAIT = "Force sending of data";
    private static final String USE_FAST = "Use fast connect ";
    private static final String FONT = "Change font";
    private static final String FONT_LARGE = "Large";
    private static final String FONT_MEDIUM = "Medium";
    private static final String FONT_SMALL = "Small";
    private static final String FONT_MONOSPACE = "Monospace";
    private static final String FONT_PROPOTIONAL = "Propotional";
    private static final String FONT_SYSTEM = "System";
    private static final String FONT_PLAIN = "Plain";
    private static final String FONT_BOLD = "Bold";
    private static final String FONT_ITALIC = "Italic";
    private static final String GUI_SHOW_NAME = "Nicklist";
    private static final String GUI_SHOW_TEXTFIELD = "Textfield";
    private static final String GUI_LIGHT = "Backlight";
    private static final String GUI_TIMESTAMP = "Timestamp";
    private static final String GUI_SHOW_MOTD = "Show motd";
    protected static Vector servers;
    protected static Stack allwindows;
    private ChoiceGroup cgsize = null;
    private ChoiceGroup cgtype = null;
    private ChoiceGroup cgstyle = null;
    private WindowItem fontPreviewItem = null;
    private Command fontOkCommand = new Command("Save", 1, 1);
    private Command guiOkCommand = new Command("Save", 1, 1);
    private Form fontform;
    private Form guiform;
    private boolean firstTime;
    protected static int[] PNG_SCROLL;
    protected static int[] PNG_SCROLLBUTTON_TOP;
    protected static int[] PNG_SCROLLBUTTON_MIDDLE;
    protected static int[] PNG_SCROLLBUTTON_BOTTOM;
    protected static int[] PNG_HEADER_FADE_START;
    protected static int[] PNG_HEADER_FADE_END;
    protected static WLIrc2 wlirc;
    protected static Displayable background_display;
    private int config_position = 0;
    protected static int left_position_window;

    public WLIrc2() {
        wlirc = this;
        System.out.println("STARTING");
        this.display = Display.getDisplay((MIDlet)this);
        this.firstTime = true;
        mainForm = new Form("WLIrc");
        allwindows = new Stack();
        this.db = new Database(this.display);
        servers = new Vector();
        debugWindow = null;
    }

    public void startApp() {
        Calendar calendar;
        if (this.firstTime) {
            this.db.load();
            this.loadPictures();
            mainForm.append("WLIrc 2.0 Beta 5\n");
            mainForm.append("By TheSverre");
            mainForm.addCommand(this.connectCommand);
            mainForm.addCommand(this.configCommand);
            mainForm.addCommand(this.advancedCommand);
            mainForm.addCommand(this.notifyCommand);
            mainForm.addCommand(this.guiCommand);
            mainForm.addCommand(this.fileBrowser);
            mainForm.addCommand(this.exitCommand);
            mainForm.setCommandListener((CommandListener)this);
            background_display = mainForm;
            this.firstTime = false;
        }
        this.display.setCurrent(background_display);
        if (this.display.getCurrent() != null) {
            if (this.db.window_height < 1) {
                this.db.window_height = this.display.getCurrent().getHeight();
            }
            if (this.db.window_width < 1) {
                this.db.window_width = this.display.getCurrent().getWidth();
            }
        }
        if (this.db.gui_light) {
            Utils.setLight(true);
        }
        if ((calendar = Calendar.getInstance()).get(1) > 2007) {
            Alert alert = new Alert("Beta version has expired! please download the newest version");
            alert.setTimeout(-2);
            this.display.setCurrent(alert, this.display.getCurrent());
            mainForm.removeCommand(this.connectCommand);
        }
    }

    public void commandAction(Command command, Item item) {
        if (command == this.testCommand) {
            Utils.notifier("Test", "This is a test", this.getNotifierTypes(), this.db, this.display, null);
        } else if (command == this.fontCommand) {
            this.fontform = new Form("Config font");
            this.cgsize = new ChoiceGroup("Size", 1);
            this.cgsize.append(FONT_LARGE, null);
            this.cgsize.append(FONT_MEDIUM, null);
            this.cgsize.append(FONT_SMALL, null);
            this.cgsize.setSelectedIndex(this.db.font_size, true);
            this.fontform.append((Item)this.cgsize);
            this.cgtype = new ChoiceGroup("Type", 1);
            this.cgtype.append(FONT_MONOSPACE, null);
            this.cgtype.append(FONT_PROPOTIONAL, null);
            this.cgtype.append(FONT_SYSTEM, null);
            this.cgtype.setSelectedIndex(this.db.font_face, true);
            this.fontform.append((Item)this.cgtype);
            this.cgstyle = new ChoiceGroup("Style", 1);
            this.cgstyle.append(FONT_PLAIN, null);
            this.cgstyle.append(FONT_BOLD, null);
            this.cgstyle.append(FONT_ITALIC, null);
            this.cgstyle.setSelectedIndex(this.db.font_style, true);
            this.fontform.append((Item)this.cgstyle);
            this.fontform.setItemStateListener((ItemStateListener)this);
            this.db.font_face = this.cgtype.getSelectedIndex();
            this.db.font_size = this.cgsize.getSelectedIndex();
            this.db.font_style = this.cgstyle.getSelectedIndex();
            this.fontPreviewItem = new WindowItem("Preview", this.db, null, this.fontform.getWidth(), 70);
            this.fontPreviewItem.addText(new Message("QWERTYUIOPASDFGHJKLZXCVBNM 1234567890", 1));
            this.fontform.append((Item)this.fontPreviewItem);
            this.fontform.addCommand(this.fontOkCommand);
            this.fontform.addCommand(this.cancelCommand);
            this.fontform.setCommandListener((CommandListener)this);
            this.display.setCurrent((Displayable)this.fontform);
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        System.out.println("Command " + command);
        if (this.display.getCurrent().equals(this.profileList) && command == List.SELECT_COMMAND) {
            command = this.editCommand;
        }
        if (command == this.exitCommand) {
            this.destroyApp(false);
            this.notifyDestroyed();
        } else if (command == this.resumeCommand) {
            ((Listener)WLIrc2.servers.elementAt((int)0)).console.show();
        } else if (command == this.fileBrowser) {
            new Thread(new DCC(this.display, this.display.getCurrent())).start();
        } else if (this.notifyList != null && command == List.SELECT_COMMAND) {
            String string = this.notifyList.getString(this.notifyList.getSelectedIndex());
            this.notifyForm = new Form(string);
            this.cgnotifiertype = new ChoiceGroup("Select type", 2);
            this.cgnotifiertype.append(NOTIFIER_TYPE_ALERT, null);
            this.cgnotifiertype.append(NOTIFIER_TYPE_SOUND, null);
            this.cgnotifiertype.append(NOTIFIER_TYPE_LOUD_SOUND, null);
            this.cgnotifiertype.append(NOTIFIER_TYPE_FLASHLIGT, null);
            this.cgnotifiertype.append(NOTIFIER_TYPE_VIBRATE, null);
            this.cgnotifiertype.append(NOTIFIER_TYPE_BACKGROUND, null);
            boolean[] blArray = new boolean[6];
            String string2 = "";
            if (string.equals(NOTIFY_CHAN)) {
                string2 = this.db.notifier_CHAN;
            } else if (string.equals(NOTIFY_FRIEND)) {
                string2 = this.db.notifier_FRIEND;
            } else if (string.equals(NOTIFY_PRIV)) {
                string2 = this.db.notifier_PRIV;
            }
            blArray[0] = string2.indexOf("A") > -1;
            blArray[1] = string2.indexOf("s") > -1;
            blArray[2] = string2.indexOf("S") > -1;
            blArray[3] = string2.indexOf("F") > -1;
            blArray[4] = string2.indexOf("V") > -1;
            blArray[5] = string2.indexOf("B") > -1;
            this.cgnotifiertype.setSelectedFlags(blArray);
            this.notifyForm.append((Item)this.cgnotifiertype);
            this.notifyForm.addCommand(this.okCommand);
            this.notifyForm.addCommand(this.cancelCommand);
            this.notifyForm.setCommandListener((CommandListener)this);
            this.buttonTest = new StringItem("Test", string, 2);
            this.buttonTest.addCommand(this.testCommand);
            this.buttonTest.setDefaultCommand(this.testCommand);
            this.buttonTest.setItemCommandListener((ItemCommandListener)this);
            this.notifyForm.append((Item)this.buttonTest);
            this.display.setCurrent((Displayable)this.notifyForm);
        } else if (this.notifyForm != null && displayable.equals(this.notifyForm) && command == this.okCommand) {
            String string = this.getNotifierTypes();
            String string3 = this.notifyForm.getTitle();
            if (string3.equals(NOTIFY_CHAN)) {
                this.db.notifier_CHAN = string;
            } else if (string3.equals(NOTIFY_PRIV)) {
                this.db.notifier_PRIV = string;
            } else if (string3.equals(NOTIFY_FRIEND)) {
                this.db.notifier_FRIEND = string;
            }
            this.db.save(2);
            this.display.setCurrent((Displayable)this.notifyList);
            this.notifyForm = null;
        } else if (this.notifyForm != null && displayable.equals(this.notifyForm) && command == this.okCommand) {
            this.notifyForm = null;
            this.display.setCurrent((Displayable)this.notifyList);
        } else if (command == this.connectCommand) {
            if (this.display.getCurrent().equals(this.profileList)) {
                WLIrc2.addServer((Profile)this.db.profiles.elementAt(this.profileList.getSelectedIndex()), this.display, this.db);
            } else {
                Enumeration enumeration = this.db.profiles.elements();
                while (enumeration.hasMoreElements()) {
                    Profile profile = (Profile)enumeration.nextElement();
                    System.err.println("profile: " + profile);
                    if (!profile.autoconnect) continue;
                    if (profile.nick == null || profile.nick.equals("")) {
                        Alert alert = new Alert("Warning", "Nick must be set! (Is set under config)", null, AlertType.WARNING);
                        alert.setTimeout(-2);
                        this.display.setCurrent((Displayable)alert);
                        return;
                    }
                    WLIrc2.addServer(profile, this.display, this.db);
                }
            }
        } else if (command == this.newprofileCommand) {
            Profile profile = this.setProfile(new Profile());
            this.db.profiles.addElement(profile);
            this.db.save(4);
            this.addProfiles();
        } else if (command == this.removeCommand) {
            this.db.profiles.removeElementAt(this.profileList.getSelectedIndex());
            this.db.save(4);
            this.addProfiles();
        } else if (command == this.configCommand) {
            if (this.db.profiles.size() > 1) {
                this.addProfiles();
            } else {
                this.addConfiguration(this.db, 0);
            }
        } else if (this.advancedList != null && command == List.SELECT_COMMAND) {
            System.err.println("HI: ");
            String string = this.advancedList.getString(this.advancedList.getSelectedIndex());
            this.configForm = new Form(string);
            System.err.println("NAME: " + string);
            if (string.equals(ADVANCED_CONNECTION)) {
                this.cgconnection = new ChoiceGroup("Connection type", 1);
                this.cgconnection.append(CON_SOCKET, null);
                this.cgconnection.append("Http", null);
                this.cgconnection.append(CON_BLUETOOTH, null);
                this.cgconnection.setSelectedIndex(this.db.connection, true);
                this.cgdcc = new ChoiceGroup(null, 2);
                this.cgdcc.append(DCC_PROXY, null);
                this.cgdcc.append(SOCKET_POLL, null);
                boolean[] blArray = new boolean[]{this.db.dcc_proxy, this.db.socket_poll};
                this.cgdcc.setSelectedFlags(blArray);
                this.configForm.append((Item)this.cgdcc);
                this.configForm.append((Item)this.cgconnection);
            } else if (string.equals(ADVANCED_DCC)) {
                this.tfgateway = new TextField("Proxy server", this.db.dcc_proxy_server, 50, 0);
                this.tfport = new TextField("Port", new Integer(this.db.dcc_proxy_port).toString(), 5, 2);
                this.configForm.append((Item)this.tfgateway);
                this.configForm.append((Item)this.tfport);
            } else if (string.equals("Http")) {
                this.tfgateway = new TextField("Gateway", this.db.gateway, 800, 4);
                this.configForm.append((Item)this.tfgateway);
                this.tfpolltime = new TextField("Poll time", new Integer(this.db.polltime).toString(), 4, 2);
                this.configForm.append((Item)this.tfpolltime);
                this.cgwait = new ChoiceGroup(null, 2);
                this.cgwait.append(USE_WAIT, null);
                this.cgwait.append(USE_FAST, null);
                boolean[] blArray = new boolean[]{this.db.waitafterdata, this.db.fastconnect};
                this.cgwait.setSelectedFlags(blArray);
                this.configForm.append((Item)this.cgwait);
            } else if (string.equals(ADVANCED_ENCODING)) {
                this.cgencoding = new ChoiceGroup("Encoding", 1);
                this.cgencoding.append("Western europe (ISO-8859-1)", null);
                this.cgencoding.append("Eastern europe (ISO-8859-2)", null);
                this.cgencoding.append("Russian (Koi8r)", null);
                this.cgencoding.append("Cyrrilic (cp1251)", null);
                this.cgencoding.append("Baltic (cp1257)", null);
                String string4 = "";
                this.db.encoding = this.db.encoding.toLowerCase();
                System.err.println("DBENC: " + this.db.encoding);
                if (this.db.encoding.equals("ISO-8859-1")) {
                    this.cgencoding.setSelectedIndex(0, true);
                } else if (Encoding.isiso8859_2(this.db.encoding)) {
                    this.cgencoding.setSelectedIndex(1, true);
                } else if (Encoding.iskoi8r(this.db.encoding)) {
                    this.cgencoding.setSelectedIndex(2, true);
                } else if (Encoding.iscp1251(this.db.encoding)) {
                    this.cgencoding.setSelectedIndex(3, true);
                } else if (Encoding.iscp1257(this.db.encoding)) {
                    this.cgencoding.setSelectedIndex(4, true);
                } else {
                    string4 = this.db.encoding;
                }
                this.configForm.append((Item)this.cgencoding);
                this.tfEncoding = new TextField("Other", string4, 15, 0);
                this.configForm.append((Item)this.tfEncoding);
            }
            this.configForm.addCommand(this.okCommand);
            this.configForm.addCommand(this.cancelCommand);
            this.configForm.setCommandListener((CommandListener)this);
            this.display.setCurrent((Displayable)this.configForm);
        } else if (command == this.advancedCommand) {
            this.advancedList = new List("Advanced", 3);
            this.advancedList.append(ADVANCED_CONNECTION, null);
            this.advancedList.append(ADVANCED_SERVER, null);
            this.advancedList.append(ADVANCED_ENCODING, null);
            if (this.db.connection == 1) {
                this.advancedList.append("Http", null);
            }
            if (this.db.dcc_proxy) {
                this.advancedList.append(ADVANCED_DCC, null);
            }
            this.advancedList.setCommandListener((CommandListener)this);
            this.display.setCurrent((Displayable)this.advancedList);
        } else if (command == this.notifyCommand) {
            this.notifyList = new List("Notifiers", 3);
            this.notifyList.append(NOTIFY_FRIEND, null);
            this.notifyList.append(NOTIFY_CHAN, null);
            this.notifyList.append(NOTIFY_PRIV, null);
            this.notifyList.addCommand(this.cancelCommand);
            this.notifyList.setCommandListener((CommandListener)this);
            this.display.setCurrent((Displayable)this.notifyList);
        } else if (command == this.editCommand) {
            this.addConfiguration(this.db, this.profileList.getSelectedIndex());
        } else if (command == this.addProfileCommand) {
            this.db.profiles.addElement(new Profile());
            this.addConfiguration(this.db, this.db.profiles.size() - 1);
        } else if (command == this.editCommand) {
            this.db.profiles.removeElementAt(this.profileList.getSelectedIndex());
            this.db.save(4);
        } else if (command == this.okCommand) {
            String string = ((Form)displayable).getTitle();
            if (string.equals("Config")) {
                if (this.tfhost == null) {
                    this.display.setCurrent((Displayable)mainForm);
                    return;
                }
                if (this.tfnick.getString() == null || this.tfnick.getString().equals("")) {
                    Alert alert = new Alert("Warning", "Nick must be set", null, AlertType.WARNING);
                    alert.setTimeout(-2);
                    this.display.setCurrent((Displayable)alert);
                    return;
                }
                Profile profile = (Profile)this.db.profiles.elementAt(this.config_position);
                profile = this.setProfile(profile);
                this.db.profiles.setElementAt(profile, this.config_position);
                this.db.save(4);
            } else {
                System.err.println("TITLE: " + string);
                if (string.equals(ADVANCED_CONNECTION)) {
                    this.db.connection = this.cgconnection.getSelectedIndex();
                    boolean[] blArray = new boolean[2];
                    this.cgdcc.getSelectedFlags(blArray);
                    this.db.socket_poll = blArray[1];
                    this.db.dcc_proxy = blArray[0];
                } else if (string.equals(ADVANCED_DCC)) {
                    this.db.dcc_proxy_port = Integer.parseInt(this.tfport.getString());
                    this.db.dcc_proxy_server = this.tfgateway.getString();
                } else if (string.equals("Http")) {
                    this.db.gateway = this.tfgateway.getString();
                    boolean[] blArray = new boolean[2];
                    this.cgwait.getSelectedFlags(blArray);
                    this.db.waitafterdata = blArray[0];
                    this.db.fastconnect = blArray[1];
                    this.db.polltime = Integer.parseInt(this.tfpolltime.getString());
                } else if (string.equals(ADVANCED_ENCODING)) {
                    int n = this.cgencoding.getSelectedIndex();
                    System.err.println("ENCODING: " + n);
                    switch (n) {
                        case 0: {
                            this.db.encoding = "ISO-8859-1";
                            break;
                        }
                        case 1: {
                            this.db.encoding = "ISO-8859-2";
                            break;
                        }
                        case 2: {
                            this.db.encoding = "KOI8R";
                            break;
                        }
                        case 3: {
                            this.db.encoding = "CP1251";
                            break;
                        }
                        case 4: {
                            this.db.encoding = "CP1257";
                            break;
                        }
                        default: {
                            this.db.encoding = this.tfEncoding.getString();
                        }
                    }
                    System.err.println("ENC: " + this.db.encoding);
                }
            }
            this.db.save(2);
            this.tfhost = null;
            this.tfgateway = null;
            this.configForm = null;
            this.cgdebug = null;
            this.cgconnection = null;
            this.cgdebug = null;
            this.cgwait = null;
            this.tfchannel = null;
            this.tfpolltime = null;
            this.tfnick = null;
            this.tffriends = null;
            this.tfrealname = null;
            this.tfStartupScript = null;
            this.tfpassword = null;
            this.tfport = null;
            this.tfEncoding = null;
            this.tfmaxLinesWindow = null;
            this.display.setCurrent((Displayable)mainForm);
        } else if (command == this.cancelCommand) {
            this.tfhost = null;
            this.tfgateway = null;
            this.configForm = null;
            this.cgconnection = null;
            this.cgdebug = null;
            this.tfchannel = null;
            this.tfnick = null;
            this.tfrealname = null;
            this.tfpolltime = null;
            this.tffriends = null;
            this.cgsize = null;
            this.cgtype = null;
            this.cgstyle = null;
            this.tfStartupScript = null;
            this.tfpassword = null;
            this.tfport = null;
            this.tfEncoding = null;
            this.tfmaxLinesWindow = null;
            this.display.setCurrent((Displayable)mainForm);
        } else if (command == this.guiCommand) {
            this.guiform = new Form("Display settings");
            this.cggui = new ChoiceGroup(null, 2);
            this.cggui.append(GUI_SHOW_TEXTFIELD, null);
            this.cggui.append(GUI_SHOW_NAME, null);
            this.cggui.append(GUI_LIGHT, null);
            this.cggui.append(GUI_TIMESTAMP, null);
            this.cggui.append(GUI_SHOW_MOTD, null);
            boolean[] blArray = new boolean[]{this.db.gui_show_textfield, this.db.gui_show_names, this.db.gui_light, this.db.gui_timestamp, this.db.show_motd};
            this.cggui.setSelectedFlags(blArray);
            this.guiform.append((Item)this.cggui);
            this.buttonFont = new StringItem(null, FONT, 2);
            this.buttonFont.addCommand(this.fontCommand);
            this.buttonFont.setDefaultCommand(this.fontCommand);
            this.buttonFont.setItemCommandListener((ItemCommandListener)this);
            this.guiform.append((Item)this.buttonFont);
            this.guiform.addCommand(this.guiOkCommand);
            this.guiform.addCommand(this.cancelCommand);
            this.guiform.setCommandListener((CommandListener)this);
            this.cgdebug = new ChoiceGroup("Information", 1);
            this.cgdebug.append(INFO_LITTLE, null);
            this.cgdebug.append(INFO_NORMAL, null);
            this.cgdebug.setSelectedIndex(this.db.debug, true);
            this.guiform.append((Item)this.cgdebug);
            this.tfmaxLinesWindow = new TextField("Max lines in window", new Integer(this.db.maxLinesInWindow).toString(), 5, 2);
            this.guiform.append((Item)this.tfmaxLinesWindow);
            this.tfwindowheight = new TextField("Window height", new Integer(this.db.window_height).toString(), 5, 2);
            this.tfwindowwidth = new TextField("Window Width", new Integer(this.db.window_width).toString(), 5, 2);
            this.guiform.append((Item)this.tfwindowheight);
            this.guiform.append((Item)this.tfwindowwidth);
            this.display.setCurrent((Displayable)this.guiform);
        } else if (command == this.fontOkCommand && this.cgsize != null) {
            this.db.font_face = this.cgtype.getSelectedIndex();
            this.db.font_size = this.cgsize.getSelectedIndex();
            this.db.font_style = this.cgstyle.getSelectedIndex();
            this.db.save(2);
            this.cgsize = null;
            this.cgtype = null;
            this.cgstyle = null;
            this.display.setCurrent((Displayable)mainForm);
        } else if (command == this.guiOkCommand && this.cggui != null) {
            boolean[] blArray = new boolean[5];
            this.cggui.getSelectedFlags(blArray);
            this.db.gui_show_textfield = blArray[0];
            this.db.gui_show_names = blArray[1];
            this.db.gui_light = blArray[2];
            this.db.gui_timestamp = blArray[3];
            this.db.show_motd = blArray[4];
            this.db.debug = this.cgdebug.getSelectedIndex();
            this.db.maxLinesInWindow = Integer.parseInt(this.tfmaxLinesWindow.getString());
            this.db.window_height = Integer.parseInt(this.tfwindowheight.getString());
            this.db.window_width = Integer.parseInt(this.tfwindowwidth.getString());
            this.db.save(2);
            this.display.setCurrent((Displayable)mainForm);
            this.cggui = null;
            this.guiform = null;
            this.buttonFont = null;
            Utils.setLight(this.db.gui_light);
        } else {
            this.display.setCurrent((Displayable)mainForm);
        }
    }

    private Profile setProfile(Profile profile) {
        profile.port = Integer.parseInt(this.tfport.getString());
        profile.host = this.tfhost.getString();
        profile.autoconnect = this.cgautoconnect.isSelected(0);
        profile.channels = this.tfchannel.getString();
        profile.nick = this.tfnick.getString();
        profile.realname = this.tfrealname.getString();
        profile.friends = this.tffriends.getString();
        profile.profilename = this.tfProfileName.getString();
        profile.startupScript = this.tfStartupScript.getString();
        profile.password = this.tfpassword.getString();
        return profile;
    }

    private void addConfiguration(Database database, int n) {
        this.config_position = n;
        Profile profile = database.profiles.size() == 0 ? new Profile() : (Profile)database.profiles.elementAt(n);
        this.configForm = new Form("Config");
        this.cgautoconnect = new ChoiceGroup(null, 2);
        this.cgautoconnect.append(AUTOCONNECT, null);
        boolean[] blArray = new boolean[]{profile.autoconnect};
        this.cgautoconnect.setSelectedFlags(blArray);
        this.configForm.append((Item)this.cgautoconnect);
        this.tfProfileName = new TextField("Profile Name", profile.profilename, 20, 0);
        this.configForm.append((Item)this.tfProfileName);
        this.tfnick = new TextField("Nick", profile.nick, 20, 0);
        this.configForm.append((Item)this.tfnick);
        this.tfrealname = new TextField("Real name", profile.realname, 50, 0);
        this.configForm.append((Item)this.tfrealname);
        this.tfchannel = new TextField(NOTIFY_CHAN, profile.channels, 600, 0);
        this.configForm.append((Item)this.tfchannel);
        this.tfhost = new TextField("Irc server", profile.host, 200, 0);
        this.configForm.append((Item)this.tfhost);
        this.tfport = new TextField("Irc server port", new Integer(profile.port).toString(), 5, 2);
        this.configForm.append((Item)this.tfport);
        this.tffriends = new TextField("Friends list seperated with ,", profile.friends, 100, 0);
        this.configForm.append((Item)this.tffriends);
        this.tfStartupScript = new TextField("Startup script (server commands separeted with ';'", profile.startupScript, 1000, 0);
        this.configForm.append((Item)this.tfStartupScript);
        this.tfpassword = new TextField("Server password", profile.password, 10, 65536);
        this.configForm.append((Item)this.tfpassword);
        this.configForm.addCommand(this.okCommand);
        this.configForm.addCommand(this.newprofileCommand);
        this.configForm.addCommand(this.cancelCommand);
        this.configForm.setCommandListener((CommandListener)this);
        this.display.setCurrent((Displayable)this.configForm);
    }

    private void addProfiles() {
        this.profileList = new List("Profiles", 3);
        Enumeration enumeration = this.db.profiles.elements();
        while (enumeration.hasMoreElements()) {
            Profile profile = (Profile)enumeration.nextElement();
            this.profileList.append(profile.profilename, null);
        }
        this.profileList.addCommand(this.editCommand);
        this.profileList.addCommand(this.connectCommand);
        this.profileList.addCommand(this.addProfileCommand);
        this.profileList.addCommand(this.cancelCommand);
        this.profileList.addCommand(this.removeCommand);
        this.profileList.setCommandListener((CommandListener)this);
        this.display.setCurrent((Displayable)this.profileList);
    }

    private String getNotifierTypes() {
        boolean[] blArray = new boolean[6];
        this.cgnotifiertype.getSelectedFlags(blArray);
        String string = "";
        if (blArray[0]) {
            string = string + "A";
        }
        if (blArray[1]) {
            string = string + "s";
        }
        if (blArray[2]) {
            string = string + "S";
        }
        if (blArray[3]) {
            string = string + "F";
        }
        if (blArray[4]) {
            string = string + "V";
        }
        if (blArray[5]) {
            string = string + "B";
        }
        return string;
    }

    public void pauseApp() {
        this.display.setCurrent(null);
    }

    public void destroyApp(boolean bl) {
    }

    public static void writeError(Exception exception, Display display, Displayable displayable) {
        exception.printStackTrace();
        System.err.println("ERROR> " + exception.toString());
        Alert alert = new Alert("Error", exception.getMessage(), null, AlertType.ERROR);
        alert.setTimeout(-2);
        display.setCurrent(alert, displayable);
    }

    public void itemStateChanged(Item item) {
        ChoiceGroup choiceGroup = (ChoiceGroup)item;
        if (choiceGroup.equals(this.cgsize)) {
            this.db.font_size = this.cgsize.getSelectedIndex();
        } else if (choiceGroup.equals(this.cgstyle)) {
            this.db.font_style = this.cgstyle.getSelectedIndex();
        } else if (choiceGroup.equals(this.cgtype)) {
            this.db.font_face = this.cgtype.getSelectedIndex();
        }
        this.fontPreviewItem.f = this.db.getFont();
        this.fontPreviewItem.update();
    }

    public void loadPictures() {
        try {
            Image image = Image.createImage((String)"/icons/scrollbutton.png");
            PNG_SCROLLBUTTON_TOP = new int[28];
            image.getRGB(PNG_SCROLLBUTTON_TOP, 0, 7, 0, 0, 7, 4);
            PNG_SCROLLBUTTON_MIDDLE = new int[7];
            image.getRGB(PNG_SCROLLBUTTON_MIDDLE, 0, 7, 0, 4, 7, 1);
            PNG_SCROLLBUTTON_BOTTOM = new int[28];
            image.getRGB(PNG_SCROLLBUTTON_BOTTOM, 0, 7, 0, 5, 7, 4);
            image = Image.createImage((String)"/icons/scroll.png");
            PNG_SCROLL = new int[7];
            image.getRGB(PNG_SCROLL, 0, 7, 0, 0, 7, 1);
            image = Image.createImage((String)"/icons/header.png");
            PNG_HEADER_FADE_START = new int[15];
            image.getRGB(PNG_HEADER_FADE_START, 0, 1, 0, 0, 1, 15);
            PNG_HEADER_FADE_END = new int[15];
            image.getRGB(PNG_HEADER_FADE_END, 0, 1, 1, 0, 1, 15);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static int getElementPosition(ScreenOutput screenOutput) {
        for (int i = 0; i < allwindows.size(); ++i) {
            if (!screenOutput.equals(allwindows.elementAt(i))) continue;
            return i;
        }
        return 0;
    }

    public static void addServer(Profile profile, Display display, Database database) {
        Listener listener = new Listener(display, database, profile);
        Irc irc = database.connection == 2 ? new BluetoothIrc(database, display, listener) : (database.connection == 1 ? new PollHttpIrc(database, display, listener) : new SocketIrc(database, display, listener));
        listener.irc = irc;
        listener.console = new Console(display, database, profile, irc, profile.profilename);
        display.setCurrent(listener.console.getDisplayable());
        servers.addElement(listener);
        new Thread(listener).start();
    }

    static {
        wlirc = null;
        background_display = null;
        left_position_window = 0;
    }
}

