/*
 * Decompiled with CFR 0.152.
 */
package wlirc2;

import java.io.IOException;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import wlirc2.Channel;
import wlirc2.Console;
import wlirc2.DCC;
import wlirc2.Database;
import wlirc2.Irc;
import wlirc2.Message;
import wlirc2.Private;
import wlirc2.Profile;
import wlirc2.ScreenOutput;
import wlirc2.Utils;
import wlirc2.WLIrc2;

public class Listener
implements Runnable {
    public static final char CTCP = '\u0001';
    public static final char ACTIONCODE = '\u0001';
    public static final char COLOR = '\u0003';
    public static final char HICOLOR = '\u0004';
    public static final char BOLD = '\u0002';
    public static final char UNDERLINE = '\u001f';
    public static final char RESET = '\u0011';
    public static final char ITALIC = '#';
    public static final char INVERT = '\u0016';
    private Database db;
    protected Profile profile;
    protected Irc irc;
    private Display display;
    private Hashtable whois;
    private boolean startup = false;
    protected Console console;
    protected Hashtable channels;
    protected Hashtable privates;

    public Listener(Display display, Database database, Profile profile) {
        this.display = display;
        this.db = database;
        this.profile = profile;
        this.whois = new Hashtable();
        this.channels = new Hashtable();
        this.privates = new Hashtable();
    }

    public void run() {
        this.start();
    }

    private void listen() throws IOException {
        String[] stringArray = this.profile.getFriends();
        long l = System.currentTimeMillis();
        long l2 = System.currentTimeMillis();
        String string = null;
        while (this.irc.isConnected()) {
            string = this.irc.readLine();
            if (string != null && !string.equals("ND")) {
                this.checkMessage(string);
            } else {
                boolean bl = this.db.waitafterdata;
                if (this.startup) {
                    bl = true;
                }
                this.irc.sendReceive(bl);
            }
            if (stringArray != null && l + 60000L < System.currentTimeMillis()) {
                String string2 = "";
                for (int i = 0; i < stringArray.length; ++i) {
                    string2 = string2 + stringArray[i] + " ";
                }
                this.irc.writeLine("ISON " + string2);
                stringArray = this.profile.getFriends();
                l = System.currentTimeMillis();
            }
            if (this.db.connection != 0 || !this.db.socket_poll || l2 + 5000L >= System.currentTimeMillis()) continue;
            this.irc.writeLine("PING :" + this.profile.host);
            l2 = System.currentTimeMillis();
        }
        this.irc.disconnect();
    }

    private void checkMessage(String string) throws IOException {
        String[] stringArray = Utils.splitString(string, " ");
        String string2 = "";
        String string3 = stringArray[1];
        int n = string.indexOf(":", 2);
        if (n != -1) {
            string2 = string.substring(n + 1);
        }
        if (string.substring(0, 4).toUpperCase().equals("PING")) {
            this.irc.writeLine("PONG " + string.substring(5));
            this.console.writeInfo("PING? PONG!");
        } else if (string3.equals("PONG")) {
            if (!this.db.socket_poll) {
                this.console.writeInfo("PONG from server " + stringArray[0].substring(1));
            }
        } else if (string3.equals("NOTICE")) {
            boolean bl = stringArray[0].indexOf("!") == -1;
            String string4 = bl ? stringArray[2] : stringArray[0].substring(1, stringArray[0].indexOf("!"));
            Message message = new Message("-" + string4 + "- " + string2, 5);
            Enumeration enumeration = WLIrc2.allwindows.elements();
            if (!bl && string2 != null && string2.length() > 0 && string2.charAt(0) == '\u0001') {
                if ((string2 = string2.substring(1).toUpperCase()).startsWith("PING")) {
                    Long l = (Long)WLIrc2.ctcplist.get(stringArray[4]);
                    if (l != null) {
                        long l2 = (System.currentTimeMillis() - l) / 1000L;
                        this.console.write(new Message("[" + string4 + " PING reply]:" + l2 + " sec", 6));
                    }
                } else if (string2.startsWith("VERSION")) {
                    this.console.write(new Message("[" + string4 + " VERSION reply]:" + string2.substring(8), 6));
                }
                return;
            }
            while (enumeration.hasMoreElements()) {
                ScreenOutput screenOutput = (ScreenOutput)enumeration.nextElement();
                if (!bl && !(screenOutput instanceof Console)) {
                    screenOutput.write(message);
                    continue;
                }
                if (!bl || !(screenOutput instanceof Console)) continue;
                screenOutput.write(message);
            }
        } else if (stringArray[0].indexOf("!") != -1) {
            String string5 = stringArray[0].substring(1, stringArray[0].indexOf("!"));
            if (string2 != null && string2.length() > 0 && string2.charAt(0) == '\u0001' && !string2.startsWith("\u0001ACTION")) {
                Object object;
                Object object2;
                if (string2.indexOf("DCC SEND") == 1) {
                    object2 = Utils.splitString(string2, " ");
                    object = new DCC(this.display, object2[2], Long.parseLong(object2[3]), object2[4], Integer.parseInt(object2[5]), string5, this.display.getCurrent());
                }
                if (string2.indexOf("FINGER") == 1) {
                    System.err.println("JA1");
                    this.irc.writeLine("NOTICE " + string5 + " :" + '\u0001' + "FINGER dont FINGER me!, i am not a tool" + '\u0001');
                }
                if (string2.indexOf("VERSION") == 1) {
                    this.irc.writeLine("NOTICE " + string5 + " :" + '\u0001' + "VERSION WLIrc " + "2.0 Beta 5" + " (" + System.getProperty("microedition.platform") + " - " + System.getProperty("microedition.locale") + " )" + '\u0001');
                }
                if (string2.indexOf("TIME") == 1) {
                    object2 = Calendar.getInstance();
                    object = ((Calendar)object2).get(1) + "." + ((Calendar)object2).get(2) + "." + (((Calendar)object2).get(5) + 1) + " " + ((Calendar)object2).get(11) + ":" + ((Calendar)object2).get(12) + ":" + ((Calendar)object2).get(13);
                    this.irc.writeLine("NOTICE " + string5 + " :" + '\u0001' + "TIME " + (String)object + '\u0001');
                    WLIrc2.wlirc.resumeRequest();
                    this.display.vibrate(1000);
                    System.err.println("RESUMEREQUEST");
                }
                if (string2.indexOf("PING") == 1) {
                    object2 = Utils.splitString(string2, " ");
                    this.irc.writeLine("NOTICE " + string5 + " :" + '\u0001' + "PING " + (String)object2[1]);
                }
            } else if (string3.equals("PRIVMSG")) {
                if (Utils.isChannel(stringArray[2])) {
                    String string6 = stringArray[2];
                    Channel channel = this.getChannel(string6, this.display, this.db, this.irc);
                    boolean bl = false;
                    if (string2.startsWith("\u0001ACTION")) {
                        string2 = string2.substring(7, string2.length());
                        bl = true;
                    }
                    channel.write(string5, string2, bl);
                    Utils.notifier(channel.getName(), string5 + "\n" + string2, this.db.notifier_CHAN, this.db, this.display, channel);
                } else {
                    Private private_ = this.getPrivate(string5, this.display, this.db, this.irc);
                    boolean bl = false;
                    if (string2.startsWith("\u0001ACTION")) {
                        string2 = string2.substring(7, string2.length());
                        bl = true;
                    }
                    Utils.notifier(string5, string2, this.db.notifier_PRIV, this.db, this.display, private_);
                    private_.write(string5, string2, bl);
                }
            } else if ("NICK".equals(string3)) {
                this.nickChange(string2, string5);
                if (string5.toUpperCase().equals(this.profile.nick.toUpperCase())) {
                    this.profile.nick = string2;
                }
            } else if ("QUIT".equals(string3)) {
                Hashtable hashtable = this.channels;
                Enumeration enumeration = hashtable.elements();
                while (enumeration.hasMoreElements()) {
                    Channel channel = (Channel)enumeration.nextElement();
                    if (channel.hasName(string5)) {
                        channel.write(new Message(string5 + " has quit irc (" + string2 + ")", 4));
                        channel.deleteName(string5);
                    }
                    channel.updateHeader();
                }
            } else if ("JOIN".equals(string3)) {
                String string7 = string2;
                Channel channel = this.getChannel(string7, this.display, this.db, this.irc);
                channel.writeInfo(string5 + " has joined " + string7);
                channel.addName(string5);
                channel.witem.setListWidth();
                channel.updateHeader();
            } else if ("PART".equals(string3)) {
                String string8 = stringArray[2];
                Channel channel = (Channel)this.channels.get(string8.toUpperCase());
                if (channel != null) {
                    channel.writeInfo(string5 + " left " + string8);
                    channel.deleteName(string5);
                    channel.witem.setListWidth();
                    channel.updateHeader();
                }
            } else if ("KICK".equals(string3)) {
                String string9 = stringArray[2];
                Channel channel = this.getChannel(string9, this.display, this.db, this.irc);
                String string10 = stringArray[3];
                if (string10.toUpperCase().equals(this.profile.nick.toUpperCase())) {
                    String string11 = "You have been kicked from " + string9 + " of " + string5 + " (" + string2 + ")";
                    this.console.writeInfo(string11);
                    Alert alert = new Alert("Kicked", string11, null, AlertType.INFO);
                    alert.setTimeout(3000);
                    this.display.setCurrent(alert, this.console.getDisplayable());
                } else {
                    String string12 = string10 + " have been kicked from " + string9 + " of " + string5 + " (" + string2 + ")";
                    channel.deleteName(string10);
                    channel.witem.setListWidth();
                    channel.updateHeader();
                    channel.writeInfo(string12);
                }
            } else if ("TOPIC".equals(string3)) {
                String string13 = stringArray[2];
                Channel channel = this.getChannel(string13, this.display, this.db, this.irc);
                String string14 = string5 + " changed topic to '" + string2 + "'";
                channel.topic = string2;
                channel.writeInfo(string14);
                channel.updateHeader();
            } else if ("MODE".equals(string3)) {
                char c;
                String string15 = stringArray[2];
                Channel channel = this.getChannel(string15, this.display, this.db, this.irc);
                String string16 = stringArray[3];
                String string17 = string5 + " sets mode: " + Utils.argsfrom(stringArray, 3);
                int n2 = 0;
                for (int i = 0; i < string16.length() && ((c = string16.charAt(i)) == '-' || c == '+'); ++i) {
                    char c2;
                    for (int j = i + 1; j < string16.length() && ((c2 = string16.charAt(j)) == 'v' || c2 == 'o'); ++j) {
                        ++i;
                        String string18 = stringArray[3 + ++n2];
                        channel.deleteName(string18);
                        String string19 = "";
                        if (c == '+') {
                            if (c2 == 'o') {
                                string19 = "@";
                            }
                            if (c2 == 'v') {
                                string19 = "+";
                            }
                        }
                        channel.addName(string19 + string18);
                    }
                }
                channel.writeInfo(string17);
                this.console.writeInfo("Mode on chan " + string15 + " is: " + string2);
                channel.witem.setListWidth();
            }
        } else {
            int n3 = 0;
            try {
                n3 = Integer.parseInt(stringArray[1]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            String string20 = stringArray[3];
            String string21 = null;
            Alert alert = null;
            Channel channel = null;
            switch (n3) {
                case 372: {
                    if (this.db.show_motd) break;
                    string2 = null;
                    break;
                }
                case 353: {
                    channel = this.getChannel(stringArray[4], this.display, this.db, this.irc);
                    if (!channel.readinglist) {
                        channel.list.removeAllElements();
                        channel.readinglist = true;
                    }
                    String[] stringArray2 = Utils.splitString(string2, " ");
                    for (int i = 0; i < stringArray2.length; ++i) {
                        channel.addName(stringArray2[i]);
                    }
                    break;
                }
                case 366: {
                    channel = this.getChannel(stringArray[3], this.display, this.db, this.irc);
                    channel.readinglist = false;
                    string21 = "";
                    Enumeration enumeration = channel.list.elements();
                    if (channel.list.size() < 10 && !channel.showlist) {
                        while (enumeration.hasMoreElements()) {
                            string21 = string21 + (String)enumeration.nextElement();
                            if (!enumeration.hasMoreElements()) continue;
                            string21 = string21 + ", ";
                        }
                        channel.writeInfo("Nicks in channel: " + string21);
                    }
                    channel.witem.setListWidth();
                    channel.updateHeader();
                    break;
                }
                case 1: {
                    if (this.console.changenick != null) {
                        this.profile.nick = this.console.changenick;
                        this.console.changenick = null;
                    }
                    this.startupscript();
                    break;
                }
                case 332: {
                    channel = this.getChannel(stringArray[3], this.display, this.db, this.irc);
                    channel.topic = string2;
                    channel.writeInfo("Topic is '" + string2 + "'");
                    channel.updateHeader();
                    return;
                }
                case 311: {
                    string21 = "Nick: " + string20 + "\n";
                    string21 = string21 + "Name: " + string2 + "\n";
                    string21 = string21 + "Address: " + stringArray[4] + "@" + stringArray[5] + "\n";
                    this.addWhois(string20, string21);
                    break;
                }
                case 319: {
                    string21 = "Channels: " + string2 + "\n";
                    this.addWhois(string20, string21);
                    break;
                }
                case 312: {
                    string21 = "Server: " + string2 + "\n";
                    this.addWhois(string20, string21);
                    break;
                }
                case 317: {
                    string21 = "Idle: " + stringArray[4] + "seconds\n";
                    this.addWhois(string20, string21);
                    break;
                }
                case 318: {
                    string21 = (String)this.whois.get(string20);
                    alert = new Alert("Whois", string21, null, AlertType.INFO);
                    alert.setTimeout(-2);
                    this.display.setCurrent((Displayable)alert);
                    break;
                }
                case 433: {
                    break;
                }
                case 401: {
                    alert = new Alert(string20, "No such nick " + string20, null, AlertType.WARNING);
                    alert.setTimeout(-2);
                    this.display.setCurrent((Displayable)alert);
                    break;
                }
                case 303: {
                    int n4;
                    String string22 = string2;
                    Vector<String> vector = new Vector<String>();
                    if (!Utils.hasNoValue(string22)) {
                        String[] stringArray3 = Utils.splitString(string22, " ");
                        for (n4 = 0; n4 < stringArray3.length; ++n4) {
                            vector.addElement(stringArray3[n4]);
                            boolean bl = false;
                            for (int i = 0; i < this.profile.onlineusers.size(); ++i) {
                                if (!stringArray3[n4].toUpperCase().equals(((String)this.profile.onlineusers.elementAt(i)).toUpperCase())) continue;
                                bl = true;
                                break;
                            }
                            if (bl) continue;
                            Private private_ = this.getPrivate(stringArray3[n4], this.display, this.db, this.irc);
                            Utils.notifier("Friend", stringArray3[n4] + " is online!", this.db.notifier_FRIEND, this.db, this.display, private_);
                            private_.write(new Message(stringArray3[n4] + " is online!", 3));
                        }
                    }
                    for (int i = 0; i < this.profile.onlineusers.size(); ++i) {
                        n4 = 0;
                        for (int j = 0; j < vector.size(); ++j) {
                            if (!((String)vector.elementAt(j)).toUpperCase().equals(((String)this.profile.onlineusers.elementAt(i)).toUpperCase())) continue;
                            n4 = 1;
                            break;
                        }
                        if (n4 != 0) continue;
                        String string23 = Utils.trimName((String)this.profile.onlineusers.elementAt(i));
                        Private private_ = (Private)this.privates.get(string23.toUpperCase());
                        Utils.notifier("Friend", string23 + " is offline!", this.db.notifier_FRIEND, this.db, this.display, private_);
                        Message message = new Message(string23 + " is offline!", 3);
                        if (private_ != null) {
                            private_.write(message);
                        }
                        this.console.write(message);
                    }
                    this.profile.onlineusers = vector;
                }
            }
            if (!Utils.hasNoValue(string2)) {
                this.console.write(string2, false);
            }
        }
    }

    protected static String authstring(Profile profile) {
        String string = "";
        if (!Utils.hasNoValue(profile.password)) {
            string = string + "PASS " + profile.password + "\n";
        }
        string = string + "NICK " + profile.nick + "\n";
        string = string + "USER " + profile.nick + " Wireless Wireless :" + profile.realname;
        return string;
    }

    private void start() {
        try {
            this.startup = true;
            WLIrc2.background_display = this.console.getDisplayable();
            this.console.writeInfo("Connecting to " + this.profile.host + " at " + this.profile.port);
            this.irc.connect(this.profile.host, this.profile.port);
            if (!this.db.fastconnect || this.db.connection != 1) {
                this.irc.writeLine(Listener.authstring(this.profile));
            }
            this.listen();
        }
        catch (Exception exception) {
            WLIrc2.writeError(exception, this.display, (Displayable)WLIrc2.mainForm);
            this.cleanup();
        }
        WLIrc2.mainForm.removeCommand(WLIrc2.wlirc.resumeCommand);
        WLIrc2.mainForm.addCommand(WLIrc2.wlirc.connectCommand);
    }

    private void startupscript() throws IOException {
        if (!this.db.fastconnect || this.db.connection != 1) {
            this.console.writeInfo("Connected to server, starting startupscript");
            String[] stringArray = this.profile.getChannels();
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!Utils.isChannel(stringArray[i])) {
                        stringArray[i] = "#" + stringArray[i];
                    }
                    this.irc.writeLine("JOIN " + stringArray[i]);
                }
            }
            if (!Utils.hasNoValue(this.profile.startupScript)) {
                String[] stringArray2 = Utils.splitString(this.profile.startupScript, ";");
                for (int i = 0; i < stringArray2.length; ++i) {
                    this.irc.writeLine(stringArray2[i]);
                }
            }
            if (!Utils.hasNoValue(this.profile.friends)) {
                this.irc.writeLine("ISON " + this.profile.friends);
            }
        }
        this.startup = false;
    }

    private void addWhois(String string, String string2) {
        String string3 = (String)this.whois.get(string);
        string3 = string3 != null ? string3 + string2 : string2;
        this.whois.put(string, string3);
    }

    private String nickChange(String string, String string2) {
        Private private_;
        System.err.println("NICK: " + string + " - " + string2);
        String string3 = string2 + " is now known as " + string;
        String[] stringArray = this.profile.getChannels();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                Channel channel = this.getChannel(stringArray[i], this.display, this.db, this.irc);
                if (!channel.hasName(string2)) continue;
                channel.writeInfo(string3);
                channel.deleteName(string2);
                channel.addName(string);
                channel.updateHeader();
            }
        }
        if ((private_ = (Private)this.privates.get(string2 = string2.toUpperCase())) != null) {
            this.privates.remove(string2);
            this.privates.put(string2, private_);
        }
        return string;
    }

    public synchronized Channel getChannel(String string, Display display, Database database, Irc irc) {
        Channel channel = (Channel)this.channels.get((string = string.trim()).toUpperCase());
        if (channel == null) {
            channel = new Channel(display, database, this.profile, irc, string);
            this.channels.put(string.toUpperCase(), channel);
            channel.show();
        }
        return channel;
    }

    public synchronized Private getPrivate(String string, Display display, Database database, Irc irc) {
        Private private_ = (Private)this.privates.get((string = Utils.trimName(string)).toUpperCase());
        if (private_ == null) {
            private_ = new Private(display, database, this.profile, irc, string);
            this.privates.put(string.toUpperCase(), private_);
            private_.show();
        }
        return private_;
    }

    public void cleanup() {
        this.channels.clear();
        this.privates.clear();
        this.console.clear();
    }
}

