/*
 * Decompiled with CFR 0.152.
 */
package wlirc2;

import java.util.Hashtable;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import javax.microedition.midlet.MIDlet;

public class CommandHandler {
    private MIDlet midlet = null;
    private Hashtable displayables = new Hashtable();
    private Hashtable cmd2EndPoint = new Hashtable();
    private Hashtable preCmd2runnable = new Hashtable();
    private Hashtable postCmd2runnable = new Hashtable();
    private Hashtable listItemIndex2cmd = new Hashtable();
    private Hashtable exitCmds = new Hashtable();
    private Display display;
    private static CommandHandler commandHandler = null;

    public static CommandHandler getInstance() {
        if (commandHandler == null) {
            commandHandler = new CommandHandler();
        }
        return commandHandler;
    }

    public void initialize(MIDlet mIDlet) {
        this.midlet = mIDlet;
        this.display = Display.getDisplay((MIDlet)mIDlet);
    }

    public void start(Displayable displayable) {
        this.display.setCurrent(displayable);
    }

    public void registerDisplayable(Displayable displayable) {
        this.displayables.put(displayable.getClass().getName(), displayable);
    }

    public void registerCommand(Command command, String string) {
        this.cmd2EndPoint.put(command, string);
    }

    public void registerPreCommand(Command command, InvokeAble invokeAble) {
        this.preCmd2runnable.put(command, invokeAble);
    }

    public void registerPostCommand(Command command, InvokeAble invokeAble) {
        this.postCmd2runnable.put(command, invokeAble);
    }

    public void registerExitCommand(Command command, String string) {
        this.exitCmds.put(command, string);
    }

    public void registerListItemIndex2command(List list, int n, Command command) {
        if (list != null && command != null) {
            this.listItemIndex2cmd.put(list.getClass().getName() + "#" + n, command);
        }
    }

    public boolean handleCommand(Command command) {
        Displayable displayable;
        Object object;
        if (command == List.SELECT_COMMAND && this.display.getCurrent() instanceof List) {
            object = (List)this.display.getCurrent();
            int n = object.getSelectedIndex();
            command = (Command)this.listItemIndex2cmd.get(object.getClass().getName() + "#" + n);
        }
        if (command != null && this.exitCmds.containsKey(command)) {
            this.invokePreCommand(command);
            this.midlet.notifyDestroyed();
            return false;
        }
        if (command == null) {
            return false;
        }
        object = (String)this.cmd2EndPoint.get(command);
        if (object != null && (displayable = (Displayable)this.displayables.get(object)) != null) {
            this.invokePreCommand(command);
            this.display.setCurrent(displayable);
            this.invokePostCommand(command);
            return true;
        }
        return false;
    }

    private void invokePreCommand(Command command) {
        InvokeAble invokeAble = (InvokeAble)this.preCmd2runnable.get(command);
        if (invokeAble != null) {
            invokeAble.invoke();
        }
    }

    private void invokePostCommand(Command command) {
        InvokeAble invokeAble = (InvokeAble)this.postCmd2runnable.get(command);
        if (invokeAble != null) {
            invokeAble.invoke();
        }
    }

    public static interface InvokeAble {
        public void invoke();
    }
}

